import os

from .oxford_pets import OxfordPets
from .utils import DatasetBase


template = ['a photo of a {}, a type of flower.']
# template = ['a bad photo of a {}, a type of flower.',
#     'a photo of many {}, a type of flower.',
#     'a sculpture of a {}, a type of flower.',
#     'a photo of the hard to see {}, a type of flower.',
#     'a low resolution photo of the {}, a type of flower.',
#     'a rendering of a {}, a type of flower.',
#     'graffiti of a {}, a type of flower.',
#     'a bad photo of the {}, a type of flower.',
#     'a cropped photo of the {}, a type of flower.',
#     'a tattoo of a {}, a type of flower.',
#     'the embroidered {}, a type of flower.',
#     'a photo of a hard to see {}, a type of flower.',
#     'a bright photo of a {}, a type of flower.',
#     'a photo of a clean {}, a type of flower.',
#     'a photo of a dirty {}, a type of flower.',
#     'a dark photo of the {}, a type of flower.',
#     'a drawing of a {}, a type of flower.',
#     'a photo of my {}, a type of flower.',
#     'the plastic {}, a type of flower.',
#     'a photo of the cool {}, a type of flower.',
#     'a close-up photo of a {}, a type of flower.',
#     'a black and white photo of the {}, a type of flower.',
#     'a painting of the {}, a type of flower.',
#     'a painting of a {}, a type of flower.',
#     'a pixelated photo of the {}, a type of flower.',
#     'a sculpture of the {}, a type of flower.',
#     'a bright photo of the {}, a type of flower.',
#     'a cropped photo of a {}, a type of flower.',
#     'a plastic {}, a type of flower.',
#     'a photo of the dirty {}, a type of flower.',
#     'a jpeg corrupted photo of a {}, a type of flower.',
#     'a blurry photo of the {}, a type of flower.',
#     'a photo of the {}, a type of flower.',
#     'a good photo of the {}, a type of flower.',
#     'a rendering of the {}, a type of flower.',
#     'a {} in a video game, a type of flower.',
#     'a photo of one {}, a type of flower.',
#     'a doodle of a {}, a type of flower.',
#     'a close-up photo of the {}, a type of flower.',
#     'a photo of a {}, a type of flower.',
#     'the origami {}, a type of flower.',
#     'the {} in a video game, a type of flower.',
#     'a sketch of a {}, a type of flower.',
#     'a doodle of the {}, a type of flower.',
#     'a origami {}, a type of flower.',
#     'a low resolution photo of a {}, a type of flower.',
#     'the toy {}, a type of flower.',
#     'a rendition of the {}, a type of flower.',
#     'a photo of the clean {}, a type of flower.',
#     'a photo of a large {}, a type of flower.',
#     'a rendition of a {}, a type of flower.',
#     'a photo of a nice {}, a type of flower.',
#     'a photo of a weird {}, a type of flower.',
#     'a blurry photo of a {}, a type of flower.',
#     'a cartoon {}, a type of flower.',
#     'art of a {}, a type of flower.',
#     'a sketch of the {}, a type of flower.',
#     'a embroidered {}, a type of flower.',
#     'a pixelated photo of a {}, a type of flower.',
#     'itap of the {}, a type of flower.',
#     'a jpeg corrupted photo of the {}, a type of flower.',
#     'a good photo of a {}, a type of flower.',
#     'a plushie {}, a type of flower.',
#     'a photo of the nice {}, a type of flower.',
#     'a photo of the small {}, a type of flower.',
#     'a photo of the weird {}, a type of flower.',
#     'the cartoon {}, a type of flower.',
#     'art of the {}, a type of flower.',
#     'a drawing of the {}, a type of flower.',
#     'a photo of the large {}, a type of flower.',
#     'a black and white photo of a {}, a type of flower.',
#     'the plushie {}, a type of flower.',
#     'a dark photo of a {}, a type of flower.',
#     'itap of a {}, a type of flower.',
#     'graffiti of the {}, a type of flower.',
#     'a toy {}, a type of flower.',
#     'itap of my {}, a type of flower.',
#     'a photo of a cool {}, a type of flower.',
#     'a photo of a small {}, a type of flower.',
#     'a tattoo of the {}, a type of flower.']
class OxfordFlowers(DatasetBase):

    dataset_dir = 'oxford_flowers'

    def __init__(self, root):
        self.dataset_dir = os.path.join(root, self.dataset_dir)
        self.image_dir = os.path.join(self.dataset_dir, 'jpg')
        self.label_file = os.path.join(self.dataset_dir, 'imagelabels.mat')
        self.lab2cname_file = os.path.join(self.dataset_dir, 'cat_to_name.json')
        self.split_path = os.path.join(self.dataset_dir, 'split_zhou_OxfordFlowers.json')

        self.template = template

        test = OxfordPets.read_split(self.split_path, self.image_dir)
        
        super().__init__(test=test)